clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

use wf_step1001.dta, clear

keep if smpl2==1


order nuts year

collapse (firstnm) id- city_nuts, by(nuts)

gen year=1971

drop if nuts==""
capture drop _merge
* joinby nuts using step0660_wvs_collapsed_with_composite_nuts, unmatched(master)
joinby nuts using step0403_wvs_collapsed_not_in_WVS_dropped, unmatched(master)
* joinby nuts using WVS_collapse_only_cleaned, unmatched(master)
tab _merge
tab country _merge, mis
drop if nuts==""
drop if _merge==1

duplicates drop nuts year, force


*==============================================================
*			Create indexes of cultural dimensions
*==============================================================

*** sample weights that are equal for each country
egen temp_sample_size_norm=mean(sample_size) if smpl2==1 , by(country)
gen sample_size_norm=sample_size/temp_sample_size_norm


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*** 		INDEX OF WORK-IMPORTANT THINGS IN LIFE
***			High value = strong work ethic
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

pca a005 a003 a030 c037 c038 c039 c041  ///
	[aw=sample_size_norm] if smpl2==1 
capture drop WVS_index_1_pca
predict WVS_index_1_pca if smpl2==1 , score
sum WVS_index_1_pca if smpl2==1
replace WVS_index_1_pca=WVS_index_1_pca/r(sd)


gen WVS_index_1 = a005/.263 - a003/.202 + a030/.203 + c037/.423 + c038/.382 + c039/.282 + c041/.423
sum WVS_index_1 if smpl2==1
replace WVS_index_1=WVS_index_1/r(sd)

	
label var WVS_index_1_pca "WVS: INDEX OF WORK-IMPORTANT THINGS IN LIFE, PCA"
label var WVS_index_1     "WVS: INDEX OF WORK-IMPORTANT THINGS IN LIFE"


*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
***			Trust vs. Bending the rules (Civic attitudes)
***			High value = high trust
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

pca  a165  a168a f114 ///
	[aw=sample_size] if smpl2==1  
capture drop WVS_index_2_pca
predict WVS_index_2_pca if smpl2==1  , score
sum WVS_index_2_pca if smpl2==1
replace WVS_index_2_pca=WVS_index_2_pca/r(sd)

gen WVS_index_2 = -(a165/.196 - a168a/1.071 + f114/1.212)
sum WVS_index_2 if smpl2==1
replace WVS_index_2=WVS_index_2/r(sd)

reg WVS_index_2_pca WVS_index_2
if _b[WVS_index_2]<0 {
	replace WVS_index_2_pca=-WVS_index_2_pca
}
	
label var WVS_index_2_pca "WVS: Trust, PCA"
label var WVS_index_2     "WVS: Trust"

	
		
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*** 			Individualism
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*	E035: equalize incomes vs maximize individual incentives
*	E036 (public vs private ownership)

pca  a029 e035 e036 e037 e039    ///
	[aw=sample_size_norm] if smpl2==1  
capture drop WVS_index_3_pca
predict WVS_index_3_pca if smpl2==1  , score
sum WVS_index_3_pca if smpl2==1
replace WVS_index_3_pca=WVS_index_3_pca/r(sd)

gen WVS_index_3 = a029/0.17518 + e035/1.011 - e036/.696 -e039/0.754 - e037/.912531
sum WVS_index_3 if smpl2==1
replace WVS_index_3=WVS_index_3/r(sd)

reg WVS_index_3_pca WVS_index_3
if _b[WVS_index_3]<0 {
	replace WVS_index_3_pca=-WVS_index_3_pca
}
	

label var WVS_index_3_pca "WVS: Role of the state, PCA"
label var WVS_index_3     "WVS: Role of the state"


compress
save wf_step1011, replace
